/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.betteragriculture;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.deco.DecoBoulder;
import rtg.api.world.deco.DecoCrop;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.betteragriculture.RealisticBiomeBABase;

public class RealisticBiomeBAFarmlandBiome
extends RealisticBiomeBABase {
    public RealisticBiomeBAFarmlandBiome(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBAFarmlandBiome();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBAFarmlandBiome(this.getConfig(), this.baseBiome().field_76752_A, Blocks.field_150346_d.func_176223_P(), BlockUtil.getStateDirt(BlockDirt.DirtType.COARSE_DIRT), Blocks.field_150346_d.func_176223_P(), 80.0f, -0.15f, 10.0f, 0.5f);
    }

    @Override
    public void initDecos() {
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.getDistribution().setNoiseDivisor(100.0f);
        decoFallenTree.getDistribution().setNoiseFactor(6.0f);
        decoFallenTree.getDistribution().setNoiseAddend(0.8f);
        decoFallenTree.setLogConditionChance(24);
        decoFallenTree.setLogBlock(Blocks.field_150364_r.func_176223_P());
        decoFallenTree.setLeavesBlock(Blocks.field_150364_r.func_176223_P());
        decoFallenTree.setMinSize(3);
        decoFallenTree.setMaxSize(6);
        this.addDeco(decoFallenTree, this.getConfig().ALLOW_LOGS.get());
        DecoCrop decoWheat = new DecoCrop();
        decoWheat.setType(3);
        decoWheat.setChance(80);
        decoWheat.setStrengthFactor(15.0f);
        decoWheat.setMaxY(255);
        decoWheat.setSize(30);
        decoWheat.setDensity(600);
        decoWheat.setHeight(5);
        this.addDeco(decoWheat);
        DecoCrop decoBeet = new DecoCrop();
        decoBeet.setType(2);
        decoBeet.setChance(80);
        decoBeet.setStrengthFactor(12.0f);
        decoBeet.setMaxY(255);
        decoBeet.setSize(30);
        decoBeet.setDensity(500);
        decoBeet.setHeight(5);
        this.addDeco(decoBeet);
        DecoCrop decoCarrot = new DecoCrop();
        decoCarrot.setType(1);
        decoCarrot.setChance(80);
        decoCarrot.setStrengthFactor(12.0f);
        decoCarrot.setMaxY(255);
        decoCarrot.setSize(30);
        decoCarrot.setDensity(500);
        decoCarrot.setHeight(5);
        this.addDeco(decoCarrot);
        DecoCrop decoPotato = new DecoCrop();
        decoPotato.setType(0);
        decoPotato.setChance(80);
        decoPotato.setStrengthFactor(12.0f);
        decoPotato.setMaxY(255);
        decoPotato.setSize(30);
        decoPotato.setDensity(500);
        decoPotato.setHeight(5);
        this.addDeco(decoPotato);
        DecoShrub decoShrubOak = new DecoShrub();
        decoShrubOak.setMaxY(90);
        decoShrubOak.setLoopMultiplier(2.0f);
        decoShrubOak.setChance(4);
        this.addDeco(decoShrubOak);
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.setBoulderBlock(BlockUtil.getStateDirt(BlockDirt.DirtType.PODZOL));
        decoBoulder.setChance(24);
        decoBoulder.setMaxY(80);
        decoBoulder.setStrengthFactor(4.0f);
        this.addDeco(decoBoulder);
    }

    public static class SurfaceBAFarmlandBiome
    extends SurfaceBase {
        private IBlockState blockMixTop;
        private IBlockState blockMixFiller;
        private float floMixWidth;
        private float floMixHeight;
        private float floSmallWidth;
        private float floSmallStrength;

        public SurfaceBAFarmlandBiome(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFiller, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.blockMixTop = mixTop;
            this.blockMixFiller = mixFiller;
            this.floMixWidth = mixWidth;
            this.floMixHeight = mixHeight;
            this.floSmallWidth = smallWidth;
            this.floSmallStrength = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            boolean mix = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.floMixWidth, (float)j / this.floMixWidth) + simplex.noise2f((float)i / this.floSmallWidth, (float)j / this.floSmallWidth) * this.floSmallStrength > this.floMixHeight) {
                        primer.func_177855_a(x, k, z, this.blockMixTop);
                        mix = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                if (mix) {
                    primer.func_177855_a(x, k, z, this.blockMixFiller);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBAFarmlandBiome
    extends TerrainBase {
        private float baseHeight = 67.0f;
        private float peakyHillWavelength = 15.0f;
        private float peakyHillStrength = 5.0f;
        private float smoothHillWavelength = 20.0f;
        private float smoothHillStrength = 20.0f;

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            this.groundNoise = TerrainBAFarmlandBiome.groundNoise(x, y, this.groundNoiseAmplitudeHills, rtgWorld);
            float h = TerrainBAFarmlandBiome.terrainGrasslandHills(x, y, rtgWorld, river, this.peakyHillWavelength, this.peakyHillStrength, this.smoothHillWavelength, this.smoothHillStrength, this.baseHeight);
            return TerrainBAFarmlandBiome.riverized(this.groundNoise + h, river);
        }
    }
}

